/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.essentials.tileentities;

import com.Da_Technomancer.essentials.blocks.ESBlocks;
import com.Da_Technomancer.essentials.blocks.ESProperties;
import com.Da_Technomancer.essentials.tileentities.ITickableTileEntity;
import javax.annotation.Nonnull;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.ObjectHolder;

@ObjectHolder(value="essentials")
public class BrazierTileEntity
extends BlockEntity
implements ITickableTileEntity {
    @ObjectHolder(value="brazier")
    public static BlockEntityType<BrazierTileEntity> TYPE = null;
    private final FuelHandler fuelHandler = new FuelHandler();

    public BrazierTileEntity(BlockPos pos, BlockState state) {
        super(TYPE, pos, state);
    }

    @Override
    public void clientTick() {
        if (this.f_58857_.m_46467_() % 10L == 0L) {
            BlockState state = this.m_58900_();
            if (state.m_60734_() != ESBlocks.brazier) {
                this.m_7651_();
                return;
            }
            ClientLevel world = (ClientLevel)this.f_58857_;
            switch ((Integer)state.m_61143_((Property)ESProperties.BRAZIER_CONTENTS)) {
                case 2: {
                    world.m_7106_((ParticleOptions)ParticleTypes.f_123756_, (double)this.f_58858_.m_123341_() + 0.25 + 0.5 * Math.random(), (double)(this.f_58858_.m_123342_() + 1) + Math.random() * 0.25, (double)this.f_58858_.m_123343_() + 0.25 + 0.5 * Math.random(), 0.0, 0.0, 0.0);
                    break;
                }
                case 3: {
                    world.m_7106_((ParticleOptions)ParticleTypes.f_123744_, (double)this.f_58858_.m_123341_() + 0.25 + 0.5 * Math.random(), (double)(this.f_58858_.m_123342_() + 1) + Math.random() * 0.25, (double)this.f_58858_.m_123343_() + 0.25 + 0.5 * Math.random(), 0.0, 0.0, 0.0);
                    break;
                }
                case 6: {
                    world.m_7106_((ParticleOptions)ParticleTypes.f_123759_, (double)this.f_58858_.m_123341_() + 0.25 + 0.5 * Math.random(), (double)(this.f_58858_.m_123342_() + 1) + Math.random() * 0.25, (double)this.f_58858_.m_123343_() + 0.25 + 0.5 * Math.random(), 0.0, 0.0, 0.0);
                }
            }
        }
    }

    public ItemStack useItem(ItemStack stack) {
        int type = (Integer)this.m_58900_().m_61143_((Property)ESProperties.BRAZIER_CONTENTS);
        ItemStack out = stack;
        if (type == 0) {
            int tar = -1;
            if (stack.m_41720_() == Items.f_42447_) {
                tar = 1;
                out = new ItemStack((ItemLike)Items.f_42446_);
            } else if (stack.m_41720_() == Items.f_42448_) {
                tar = 2;
                out = new ItemStack((ItemLike)Items.f_42446_);
            } else {
                tar = this.getIdentifierForRawItem(stack);
                if (tar >= 0) {
                    out = stack.m_41777_();
                    out.m_41774_(1);
                }
            }
            if (tar >= 0) {
                this.f_58857_.m_46597_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)ESProperties.BRAZIER_CONTENTS, (Comparable)Integer.valueOf(tar)));
                return out;
            }
        } else {
            switch (type) {
                case 1: {
                    if (stack.m_41720_() != Items.f_42446_ || stack.m_41613_() != 1) break;
                    this.f_58857_.m_46597_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)ESProperties.BRAZIER_CONTENTS, (Comparable)Integer.valueOf(0)));
                    return new ItemStack((ItemLike)Items.f_42447_);
                }
                case 2: {
                    if (stack.m_41720_() != Items.f_42446_ || stack.m_41613_() != 1) break;
                    this.f_58857_.m_46597_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)ESProperties.BRAZIER_CONTENTS, (Comparable)Integer.valueOf(0)));
                    return new ItemStack((ItemLike)Items.f_42448_);
                }
                default: {
                    ItemStack removed;
                    if (!stack.m_41619_() || (removed = this.getRawItemFromIdentifier(type)).m_41619_()) break;
                    this.f_58857_.m_46597_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)ESProperties.BRAZIER_CONTENTS, (Comparable)Integer.valueOf(0)));
                    return removed;
                }
            }
        }
        return stack;
    }

    private int getIdentifierForRawItem(ItemStack stack) {
        if (stack.m_41720_() == Blocks.f_50353_.m_5456_()) {
            return 3;
        }
        if (stack.m_41720_() == Blocks.f_50141_.m_5456_()) {
            return 4;
        }
        if (stack.m_41720_() == Blocks.f_50135_.m_5456_()) {
            return 6;
        }
        return -1;
    }

    private ItemStack getRawItemFromIdentifier(int identifier) {
        return switch (identifier) {
            case 3 -> new ItemStack((ItemLike)Blocks.f_50353_);
            case 4 -> new ItemStack((ItemLike)Blocks.f_50141_);
            case 6 -> new ItemStack((ItemLike)Blocks.f_50135_);
            default -> ItemStack.f_41583_;
        };
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return LazyOptional.of(() -> this.fuelHandler);
        }
        return super.getCapability(cap, side);
    }

    private class FuelHandler
    implements IItemHandler {
        private FuelHandler() {
        }

        public int getSlots() {
            return 1;
        }

        public ItemStack getStackInSlot(int slot) {
            if (slot != 0) {
                return ItemStack.f_41583_;
            }
            return BrazierTileEntity.this.getRawItemFromIdentifier((Integer)BrazierTileEntity.this.m_58900_().m_61143_((Property)ESProperties.BRAZIER_CONTENTS));
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            int tar;
            if (slot == 0 && (Integer)BrazierTileEntity.this.m_58900_().m_61143_((Property)ESProperties.BRAZIER_CONTENTS) == 0 && (tar = BrazierTileEntity.this.getIdentifierForRawItem(stack)) >= 0) {
                if (!simulate) {
                    BrazierTileEntity.this.f_58857_.m_46597_(BrazierTileEntity.this.f_58858_, (BlockState)BrazierTileEntity.this.f_58857_.m_8055_(BrazierTileEntity.this.f_58858_).m_61124_((Property)ESProperties.BRAZIER_CONTENTS, (Comparable)Integer.valueOf(tar)));
                }
                ItemStack out = stack.m_41777_();
                out.m_41774_(1);
                return out;
            }
            return stack;
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (slot == 0) {
                ItemStack out = this.getStackInSlot(0);
                if (!simulate) {
                    BrazierTileEntity.this.f_58857_.m_46597_(BrazierTileEntity.this.f_58858_, (BlockState)BrazierTileEntity.this.m_58900_().m_61124_((Property)ESProperties.BRAZIER_CONTENTS, (Comparable)Integer.valueOf(0)));
                }
                return out;
            }
            return ItemStack.f_41583_;
        }

        public int getSlotLimit(int slot) {
            return slot == 0 ? 1 : 0;
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return slot == 0 && BrazierTileEntity.this.getIdentifierForRawItem(stack) >= 0;
        }
    }
}

